/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Based on the shader Ellipse - Distance of iq : https://www.shadertoy.com/view/4sS3zz

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (fragCoord*2.-iResolution.xy)/iResolution.y;

    float t = sin(iGlobalTime*0.2);
	float a = atan(uv.x, uv.y)/3.14159*3.;
    
    float d = length( uv) - mix(3.5,.5,cos(fract(a)-.5));
    
    
    vec3 col = vec3(1.0) - sign(d)*vec3(0.1,0.4,0.7);
	col *= 1.0 - exp(-2.0*abs(d));
	col *= 0.8 + 0.2*cos(120.0*abs(d)+iGlobalTime*10.);
	col = mix( col, vec3(1.0), 1.0-smoothstep(0.0,0.02,abs(d)) );

	fragColor = vec4( col, 1.0 );;
}

void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
} 